BITLEN2         .set    54h     ;0078h   ;JUMP CMD
BITLEN          .set    0a8h    ;079h   ;JUMP XMIT
SENDC           .set    08f0h
;===============================
     .ds 0x60                   ; AIC/FFT Setup data in upper 1/2 B2
TA              .word   12      ;
TB              .word   42      ;
AIC_CMD         .word   0x0003  ; 0x72  0000 0000 0000 0011=0x0003
SIG_DEL         .word   0x0000  ; 0x73
STAT1           .word   0x0000  ; 0x74
ACCU_lo         .word   0x0000  ; 0x75
ACCU_hi         .word   0x0000  ; 0x76
REAL            .word   0x0000  ; 0x77
IMAG            .word   0x0000  ; 0x78
AUX0            .word   0x0000  ; 0x79
AUX1            .word   0x0000  ; 0x7A
FFT_S           .word   256     ;
FFT_S-1         .word   255     ;
FFT_S/2         .word   128     ;
FFT_S/2-1       .word   127     ;
scratch         .word   0
	.ds 0x300
FFT_N		    .word   256     ;my data
FFT_N/2-1       .word   127     ;my data
FFT_N-1	    .word   255     ;my data
;----------------------------------------------------------------
;    SECONDARY VECTOR TABLE LOCATED IN B0 PROGRAM RAM
;----------------------------------------------------------------
        .mmregs                 ;
        .ps     080ah           ;
        B       RINT            ;RINT  Branch to receive interrupt routine
        B       XINT            ;XINT  XINT is only for timing, so just return
                                ;
;----------------------------------------------------------------
;    APPLICATION CODE IS LOCATED ABOVE DSKD KERNAL
;----------------------------------------------------------------
        .ps     0x0a00          ;
        .entry                  ;
	;*************************************
	;calcolo di p-1 e salvataggio in S_END
	;*************************************
START: MAR *,AR5		;ARP->AR5				;calcola p-1 e salva in S_END
	LAR AR5,#ffffh	;AR5=-1
	LDP #06h
	LACL FFT_N		;ACC=FFT_N
DIV4:	SFR			;ACC=ACC*2
	SFR			;ACC=ACC*2
	BCND END,LEQ	;SALTA A END SE ACC<=0
	MAR *+		;AR5=AR5+1
	B DIV4		;SALTA A DIV4
END:	LDP #30h		;DP=30h
	SAR AR5,S_END	;S_END=P-1
	;*************************************
	;calcolo delle posizioni 2bit-reversed
	;*************************************
	LDP #6h		;DP=6h
	LACL FFT_N		;ACC=N
	SFR			;ACC=N/2
	SAMM INDX		;INDX=N/2
	SFL			;ACC=N
	SUB #2h		;ACC=N-2
	SAMM BRCR		;BRCR=N-2
	MAR *,AR0		;ARP=AR0
	;LDP #38h		; 
	LAR AR0,#_B_base	;AR0=#TAB
	LAR AR1,#0h		;AR1=0	
	;SAR AR1,*+,AR1	;#TAB=0,ARP=AR1,AR0=#TAB+1
	LACL #1h
	ADD #1000h,0	;Non potendo inserire #_D_base ho inserito una costante!
	SACL *+,0,AR1	
	RPTB ENDTB		;RIPETE N-1 VOLTE FINO A ENDTB
	MAR *BR0+,AR0	;AR1=REV,ARP=AR0
	SAR AR1,*		;#TAB+n=REV
	LACL *		;ACC=REV
	SACB			;ACCB=REV
	AND #0AAAAh		;ACC=REV AND MASK1
	SFR			;ACC=ACC>>1
	EXAR			;ACCB<->ACC
	AND #5555h		;ACC=REV AND MASK2
	SFL			;ACC=ACC<<1
	ORB			;ACC=ACC OR ACCB=2REV
	SFL
	ADD #1000h,0	;Non potendo inserire #_D_base ho inserito una costante!
	ADD #1h,0   	;
ENDTB: SACL *+,0,AR1		;#TAB+n=2REV,ARP=AR1,AR0=#TAB+n+1
      ;************************************************************************
	; SETTING DSK
	;************************************************************************
        SETC    INTM
        SETC    SXM
        SETC    OVM             ; catch accumulator overflows
        LDP     #0              ; All direct addressing is to MMRs and B2
        SPLK    #0830h,PMST
        LACC    #0
        SAMM    CWSR            ; Setsoftware wait stat eto 0
        SAMM    PDWSR           ;
        SPLK    #020h,IMR       ; Using XINT syn TX & RX
                                ; initialize AIC and enable interrupts
AIC_RS  SPLK    #01h,PRD        ; To generate  10MHz from Tout
        SPLK    #20h,TCR        ; for AIC maste rclock
        MAR     *,AR0
        LACC    #0008h          ; Non continuous mode
        SACL    SPC             ; FSX as input
        LACC    #00c8h          ; 16 bit words
        SACL    SPC
        LACC    #080h           ;
        SACH    DXR
        SACL    GREG
        LAR     AR0,#0FFFFh     ; Reset AIC by pulsing BR\pin
        RPT     #500            ; and taking it high after 500 cycles
        LACC    *,0,AR0         ; (.25ms at 50ns )
        SACH    GREG
        SETC    SXM             ;
;-------------------------------
        LACC    AIC_CMD         ; AIC control
        CALL    AIC_2nd         ; call loader
        ;------------------------
        LACC    TB,2            ; AIC timing B regs
        ADD     TB,9            ;
        ADD     #2              ;
        CALL    AIC_2nd         ; call loader
        ;-----------------------
        LACC    TA,2            ; AIC timing A regs
        ADD     TA,9            ;
        CALL    AIC_2nd         ; call loader
        ;-----------------------
        LDP     #0
        LACC    #010h           ; AIC RINT
        SACL    IMR             ; where INT0 indicates EOC (End Of Conv)
;************************************************************************
MAIN:   CALL    Init_S          ; Load 512 alternating data points
	  CALL    FFT             ;      
        CALL    TO_HOST         ;
        B       MAIN      
;************************************************************************
Init_S: SPLK #00e00h,ST0
	  SPLK #0e5aCh,ST1
	  SPLK #0fc68h,DRR
	  SPLK #060C0h,DXR
	  SPLK #0010h,IMR
	  SPLK #0830h,PMST
	  SPLK #0FFFFh,INDX
	  SPLK #0000h,CWSR
	  SPLK #0FF00h,GRG
	  SPLK #03fC8h,SPCR
	  SPLK #0000h,TCR

	  LAR     AR6,#_D_base     ; _D_base = A1[n],A2[n],A1[n+1],A2[n+1],...
        LAR     AR7,#256        ;
        MAR     *,AR7             ; enable buffer fill
        CLRC    INTM            ; Fill FFT array with 512 samples
FILL    BANZ    FILL,*,AR7      ;
        SETC    INTM            ;        
        RET                     ;
*************************************************************************
TO_HOST SPLK #0ee00h,ST0
	  SPLK #0e5aCh,ST1
	  SPLK #0f748h,DRR
	  SPLK #060C0h,DXR
	  SPLK #0010h,IMR
	  SPLK #0830h,PMST
	  SPLK #0FFFFh,INDX
	  SPLK #0000h,CWSR
	  SPLK #0FF00h,GRG
	  SPLK #03CC8h,SPCR
	  SPLK #0000h,TCR
	  
        LDP  #0000h
	  LAR  AR0,#ffffh 	  
	  LAR  AR1,#8404h
	  LAR  AR2,#0a00h 	  
	  LAR  AR3,#0000h 	  
	  LAR  AR4,#0000h 	  
	  LAR  AR5,#0000h 	  
	  LAR  AR6,#1200h 	  
	  LAR  AR7,#0000h 
        
	  LACC    #80h
        CALL    BCXMIT          ; Send frame synch (START)
        CALL    BRECV           ; Wait for host start word (01Bh)
        SUB     #01Bh
        NOP                     ; Insert NOPs to ensure condition was ready
        NOP                     ; while execute BCND
        BCND    TO_HOST,NEQ
        LAR     AR3,#_D_base    ;AR3= FFT data array
        LAR     AR5,FFT_S/2-1   ;AR5= loop counter
        MAR     *,AR3           ;
more2   MAR     *+              ;skipping REAL
	  LACC    *+              ;scale log magnitude for host
	  ;LACC    *+              ;scale log magnitude for host
        ;MAR     *+              ;skipping imaginary
        RPT     #7              ;
        SFR                     ;
        CALL    XMIT            ;
        MAR     *,AR5           ;
        BANZ    more2,*-,AR3    ;
        RET
;***********************************************************************
FFT:	SPLK #2606h,ST0
	SPLK #01ACh,ST1
	;SPLK #001Ch,DRR
	;SPLK #0000h,DXR
	SPLK #0000h,IMR
	SPLK #0834h,PMST
	SPLK #0080h,INDX
	;SPLK #3CC8h,SPCR
	;SPLK #0400h,TCR
	SETC INTM
	LDP #30h		;DP=30h
	SETC SXM		;SXM=1				;abilita l'estensione con segno
	LACL #0h		;ACC=0
	SACL S_CORR		;S=0
FOR1:	LACL S_END		;ACC=P-1
	SUB S_CORR		;ACC=P-1-S
	BCND END_1,LT	;ESCI SE ACC<0
	;****************************************
	;calcolo valori utili per i for innestati
	;****************************************
	LACL S_CORR		;ACC=S				;calcola 4^s e salva in MEM_4S
	SFL			;ACC=S*2
	SUB #1h		;ACC=S*2-1	;ATT se S=0 ci sono problemi	
	BCND NO_RPT1,LT	;SALTA SE ACC=0
	SAMM BRCR
	LACL #1h
	RPTB R1
	NOP		;le NOP sono necessarie perch RPTB vuole
	NOP		;un blocco di almeno tre istruzioni
	NOP
R1:	SFL
	NOP
	B YES_RPT1
NO_RPT1:  LACL #1h	
YES_RPT1: SACL MEM_4S		;MEM_4S=4^S
	SUB #1h		;ACC=4^S-1				;calcola 4^s-1 e salva in I_END
	SACL I_END		;I_END=4^S-1			
	LACL S_END		;ACC=P-1				;calcola 4^(p-1-s) e salva in MEM_4P1S
	SUB S_CORR		;ACC=P-1-S
	SFL			;ACC=(P-1-S)*2
	SUB #1h		;ACC=(P-1-S)*2-1
	BCND NO_RPT2,LT	
	SAMM BRCR
	LACL #1h
	RPTB R2
	NOP		;le NOP sono necessarie perch RPTB vuole
	NOP		;un blocco di almeno tre istruzioni
	NOP
R2:	SFL
	NOP
	B YES_RPT2	
NO_RPT2: LACL #1h
YES_RPT2: SACL MEM_4P1S	;MEM_4P1S=4^(P-1-S)
	SUB #1h		;ACC=4^(P-1-S)-1			;calcola 4^(p-1-s)-1 e salva in J_END
	SACL J_END		;J_END=MEM_4P1S=4^(P-1-S)
	LACL S_END		;ACC=P-1				;calcola 4^(p-s) e salva in MEM_4PS
	ADD #1h		;ACC=P
	SUB S_CORR		;ACC=P-S
	SFL			;ACC=(P-S)*2
	SUB #1h		;ACC=(P-1-S)*2-1
	SAMM BRCR
	LACL #1h
	RPTB R3
	NOP		;le NOP sono necessarie perch RPTB vuole
	NOP		;un blocco di almeno tre istruzioni
	NOP
R3:	SFL
	NOP
	SACL MEM_4PS	;MEM_4PS=4^(P-S)
	;****************************************
	;fine calcolo valori 
	;****************************************
	LACL #0h		;ACC=0
	SACL I_CORR		;I_CORR=0
FOR2:	LACL I_END		;ACC=4^S-1				(#istr intern=9)
	SUB I_CORR		;ACC=4^S-1-I_CORR
	BCND END_2,LT	;SALTA A END_2 SE ACC<0
	;****************************************
	LACL #0h		;ACC=0
	SACL J_CORR		;J_CORR=0
FOR3:	LACL J_END		;ACC=4^(P-1-S)-1			(#ISTR = 116)
	SUB J_CORR		;ACC=4^(P-1-S)-1-J_CORR
	BCND END_3,LT	;SALTA A END_3 SE ACC<0
	;****************************************
	;calcolo butterfly
	;****************************************
	;inizializzazione AR0-4   (#ISTR = 21)
	;****************************************
	NOP
	LAR AR0,#TEMP_realF	;AR0=#TEMP_realF
	LAR AR1,#_D_base		;AR1=#_D_base
	LAR AR2,#_D_base		;AR2=#_D_base
	LAR AR3,#_D_base		;AR3=#_D_base
	LAR AR4,#_D_base		;AR4=#_D_base
	LT MEM_4PS		;TREG=4^(P-S)
	MPY I_CORR		;P=I*4^(P-S)
	PAC			;ACC=I*4^(P-S)
	ADD J_CORR		;ACC=I*4^(P-S)+J
	SFL			;ACC=(I*4^(P-S)+J)*2
	SAMM INDX,		;INDX=(I*4^(P-S)+J)*2,ARP=AR1	  
	NOP			;le NOP sono necessarie per aspettare che INDX sia caricato
	NOP
	MAR *0+,AR2		;AR1=#_D_base+(I*4^(P-S)+J)*2,ARP=AR2   STA GIA PUNTANDO A AR1 
      ADD MEM_4P1S,1	;ACC=(I*4^(P-S)+J)*2+4^(P-1-S)*2
	SAMM INDX		;INDX=(I*4^(P-S)+J)*2+4^(P-1-S)*2
	NOP			;le NOP sono necessarie per aspettare che INDX sia caricato
	NOP
	MAR *0+,AR3		;AR2=#_D_base+(I*4^(P-S)+J)*2+4^(P-1-S)*2
	ADD MEM_4P1S,1	;ACC=(I*4^(P-S)+J)*2+4^(P-1-S)*2*2
	SAMM INDX		;INDX=(I*4^(P-S)+J)*2+4^(P-1-S)*2*2
	NOP			;le NOP sono necessarie per aspettare che INDX sia caricato
	NOP
	MAR *0+,AR4		;AR3=#_D_base+(I*4^(P-S)+J)*2+4^(P-1-S)*2*2
	ADD MEM_4P1S,1	;ACC=(I*4^(P-S)+J)*2+4^(P-1-S)*2*3
	SAMM INDX		;INDX=(I*4^(P-S)+J)*2+4^(P-1-S)*2*3
	NOP			;le NOP sono necessarie per aspettare che INDX sia caricato
	NOP
	MAR *0+,AR1		;AR4=#_D_base+(I*4^(P-S)+J)*2+4^(P-1-S)*2*3
	;****************************************
	;butterfly    (#ISTR = 43)
	;****************************************
BF:	LACC *,14,AR3	;(realA + realC)/4
	ADD *,14,AR1
	SACH *+,1,AR3	;salva nella locazione A real
	SUB *+,15,AR0	;(realA - realC)/4
	SACH *+,1,AR1	;salva nella locazione C real
	LACC *,14,AR3	;(imagA + imagC)/4
	ADD *,14,AR1
	SACH *-,1,AR3	;salva nella locazione A imag
	SUB *-,15,AR0		;(imagA - imagC)/4
	SACH *-,1,AR2	;salva nella locazione C imag
	LACC *,14,AR4	;(realB + realD)/4
	ADD *,14,AR2
	SACH *+,1,AR4	;salva nella locazione B real
	SUB *,15		;(realB - realD)/4
	SACH *+,1,AR2	;salva nella locazione D real
	LACC *,14,AR4	;(imagB + imagD)/4
	ADD *,14,AR2
	SACH *-,1,AR4	;salva nella locazione B imag
	SUB *,15		;(imagB - imagD)/4
	SACH *,1,AR1	;salva nella locazione D imag
      LACC *,14,AR2	;(realE + realG)/4
	ADD *,14,AR1
	SACH *+,1,AR2	;salva nella locazione E real
	SUB *+,15,AR3		;(realE - realG)/4
	SACH *+,1,AR1	;salva nella locazione G real
	LACC *,14,AR2	;(imagE + imagG)/4
	ADD *,14,AR1
	SACH *-,1,AR2	;salva nella locazione E imag
	SUB *-,15,AR3		;(imagE - imagG)/4
	SACH *-,1,AR0	;salva nella locazione G imag
	LACC *+,14,AR4	;(realF + imagH)/4
	ADD *,14,AR2
	SACH *+,1,AR4	;salva nella locazione F real
	SUB *-,15,AR0	;(realF - imagH)/4
	MAR *+		;
	SACH *-,1		;salva nella variabile TEMP_realH (realH non overwr)
	LACC *+,14,AR4	;(imagF + realH)/4
	ADD *+,14
	SACH *-,1		;salva nella locazione H imag
	SUB *,15,AR2	;(imagF - realH)/4
	SACH *-,1,AR0	;salva nella locazione F imag
	LACC *,16,AR4	;
	SACH *,0,AR0	;
	;****************************************
	;moltiplicazione twiddle factor  (#ISTR = 45)
	;****************************************
	LAR AR0,#_T_base+1	;AR0=#_T_base+1
	LT J_CORR		;TREG=J
	MPY MEM_4S		;P=J*4^S
	PAC			;ACC=J*4^S
	SFL			;ACC=2*J*4^S
	SAMM INDX		;INDX=2*J*4^S
	NOP			;le NOP sono necessarie per aspettare che INDX sia caricato
	NOP
	MAR *0+,AR2		;AR0=#_T_base+2*J*4^S
	LT *+,AR0		;TREG=
	MPY *-,AR2
	LTP *,AR0
	MPY *+,AR2
	APAC
	SACH *-,1,AR0
	MPY *-,AR2
	LTP *,AR0
	MPY *+,AR2
	SPAC
	NEG
	SACH *,1,AR0
	MAR *0+,AR3
	LT *+,AR0
	MPY *-,AR3
	LTP *,AR0
	MPY *+,AR3
	APAC
	SACH *-,1,AR0
	MPY *-,AR3
	LTP *,AR0
	MPY *+,AR3
	SPAC
	NEG
	SACH *,1,AR0
	MAR *0+,AR4
	LT *+,AR0
	MPY *-,AR4
	LTP *,AR0
	MPY *+,AR4
	APAC
	SACH *-,1,AR0
	MPY *-,AR4
	LTP *,AR0
	MPY *+,AR4
	SPAC
	NEG
	SACH *,1,AR1
	;****************************************
	;fine moltiplicazione twiddle factor
	;****************************************
	LACL J_CORR		;ACC=J_CORR
	ADD #1h		;ACC=J_CORR+1
	SACL J_CORR		;J_CORR=J_CORR+1
	B FOR3		;TORNA AL CICLO FOR3
END_3: LACL I_CORR		;ACC=I_CORR
	ADD #1h		;ACC=I_CORR+1
	SACL I_CORR		;I_CORR=I_CORR+1
	B FOR2		;TORNA AL CICLO FOR2
END_2: LACL S_CORR		;ACC=S
	ADD #1h		;ACC=S+1
	SACL S_CORR		;S=S+1
	B FOR1		;TORNA AL CICLO FOR1
END_1: NOP

	  ;**********************************************************
        ; FILTRAGGIO
        ;**********************************************************
;eFFT: MAR     *,AR3           ;Transform REAL & IMAG to log magnitude
	  ;LDP     #06h
 	  ;LAR     AR5,#_D_base      ;AR5=FFT data pointer        
  	  ;LAR     AR3,FFT_N		        
	  ;MAR     *-,AR5	
;FILTER:  MAR      *,
 	  ;MAR      *-          ;  -IMAG[-1]  1-COS(nwt/N)       + 1
  	  ;LACC     *+,15       ;   IMAG[-0]  filter by post     |
   	  ;SUB      *+,16       ;  +IMAG[+1]  convolution    <--+++-->
    	  ;ADD      *-,15       ;   IMAG                        + + -.5
        ;SACH     *           ;
        ;MAR      *+,             ;   REAL
        ;MAR      *-          ;  -REAL[-1]
        ;LACC     *+,15       ;   REAL[-0]  X[-1] -2*X[0] + X[1]
        ;SUB      *+,16       ;  +REAL[+1]
        ;ADD      *-,15   ;   REAL
        ;SACH     *           ;
        ;MAR     *+,AR3          ; IMAG        
	  ;BANZ    FILTER,*-,AR5 ;keep going until all done	

        ;**********************************************************
        ;CALCOLO LOG(MODULO)
        ;**********************************************************
endFFT: MAR     *,AR3           ;Transform REAL & IMAG to log magnitude
	  LDP     #06h
        LAR     AR5,#_D_base      ;AR5=FFT data pointer        
        LAR     AR3,FFT_N		        
	  MAR     *-,AR5	
more_MAG: SQRA    *+            ;IMAG & REAL can be at most 0x7fff Q15
        LTP     *               ;MPY will result (at most) in max positive
        MPY     *,AR1           ;
        APAC                    ;output is positive Q30
        ADD     #0x1            ;Set up a floor value; log(0) not legal!
        LAR     AR1,#17          ;pre-scaling exponent shifts Y axis
        RPT     #31             ;
        NORM    *-              ;
        NOP
        NOP          
	  MAR     *,AR5      
        SACH    *,2             ;clr explicit 1.0 and sign bit from mant
        LACL    *               ;load into ACCU_lo
        SAR     AR1,*           ;then append exponent (AR1)
        ADD     *,16            ;
        RPT     #10             ;jam result into ACCU_hi
        SFL                     ;If needed, Use ADDH to saturate overflow
        SACH    *               ;
        LACC    *-              ;
        AND     #0xfffc,0       ;
        SACL    *+              ; REAL
        MAR     *+,AR3          ; IMAG        
        BANZ    more_MAG,*-,AR5 ;keep going until all done
        ;**********************************************************
        ;ORDINAMENTO 2-BIT REVERSAL  (#ISTR= 9 + 5 DI LOOP)
        ;**********************************************************
	LAR AR1,#_D_base	;AR1=#_D_base
	LAR AR3,#_B_base	;AR3=#TAB
	LACL #02h		;ACC=2
	SAMM INDX		;INDX=2
	MAR *,AR1		;ARP=AR1
	LACL FFT_N		;ACC=N
	SUB #01h		;ACC=N-1
	SAMM BRCR		;BRCR=N-1
	RPTB ENDRV		;RIPETE N VOLTE FINO A ENDRV
	LACL *0+		;ACC=_D_base(AR1),AR1=AR1+2
	MAR *,AR3		;ARP=AR3
	LAR AR2,*+		;AR2=TAB(AR3),AR3++
	MAR *,AR2		;ARP=AR2
ENDRV: SACL *,0,AR1		;_D_base(AR2)=_D_base(AR1)
      RET                     ; FFT is finished!!
        ;**********************************************************
AIC_2nd SACH    DXR
        CLRC    INTM
        IDLE
        ADD     #6,15           ;set ACCU_hi = 3 for secondary XMIT
        SACH    DXR             ;
        IDLE                    ;ACCU_hi requests 2nd XMIT
        SACL    DXR             ;
        IDLE                    ;ACCU_lo sets up registers
        SACL    DXR,2           ;close command with LSB = 00
        IDLE
        RET                     ;
*******************************************************************
; Transmitt a character
*******************************************************************
;============================================================================
; Trasmit word routine
;============================================================================
xmtwrd  SACL    scratch
        RPT     #7
        SFR
        CALL    XMIT            ; send highbyte
        LACC    scratch         ;
BCXMIT  BCND    $+4,bio         ; expect a sync (0) signal from PC
        B       $-2
;-----------------------------------------------------------------------------
; xmtbyte follows now           ; send lowbyte and return to calling pgm
;
;  'xmtbyte' requires ARP->AR0 and sets ACCU='mask for byte'
;  send startbit (0) +  databyte + stopbits (2)
;-----------------------------------------------------------------------------
XMIT    CLRC    c               ; startbit=0
        LAR     ar1,#8          ; counter: 1 startbit+ 8 databits (+ 2 stopbits)
nextbit1 BCND   snd0,nc         ; if c=1 send 1 else send 0
snd1    SETC    xf              ; send one
        B       snd
snd0    CLRC    xf
snd     RPT     #BITLEN         ; send one bit
        MAR     *,ar1
        ROR                     ; lsb(accu) -> carrybit
        BANZ    nextbit1,*-     ; repeat for entire word (10 bits)
        SETC    xf
        RPT     #BITLEN
        NOP
        RPT     #BITLEN
        NOP
        RET
;============================================================================
; Read Routine
;============================================================================
BRECV:
wait    BCNDD   STOK,bio        ;wait for start bit
        LAR     AR1,#7
        LACL    #0
        B       wait            ;
STOK    RPT     #BITLEN2        ;BITLEN is scaled and
        NOP
        MAR     *,AR1           ;number of bits - 1
WTBIT   SFR
        RPT     #BITLEN         ;decremented by 8/3 for
        NOP                     ;BITLEN/2 wait
        BCND    ZEROBT,bio
        ADD     #80h
ZEROBT  BANZ    WTBIT,*-        ;last bit ?
        RET                     ;ACC = read value

****************************************************************************
****************************************************************************
****************************************************************************
;******************************************************************
; NOTE: This code is NOT written with context restore!
;************************************************************************
RINT:   SST     #1,STAT1        ;Recover ARP from ARB by LST1
        MAR     *,AR7           ;
        BANZ    more_buf,*-,AR6 ;if buffer is full RET w/o EINT
        LAR     AR7,#0          ;
        LST     #1,STAT1        ;
        RET                     ;
more_buf                        ;
        LACC    DRR,16           ;
        SACH    *+,0              ;<<< store Ax[n], point to next
	  SACL    *+,0
        ;-----------------------
FASTRET LST     #1,STAT1        ;
        RETE                    ;
XINT:   RETE
;====================================================================
        .listoff                ;
        .ds     01000h          ;NOTE: Twiddles are relocated to
        .include "twid.asm" ;      0x400 (B2) using CONF 1
        .liston
        .end
